/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.controls.gui.GuiClickableLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.Color;

public class GuiListBox
extends GuiScrollBox {
    protected List<String> lines = new ArrayList<String>();
    public int selected = -1;

    public GuiListBox(String name, int x, int y, int width, int height, List<String> lines) {
        super(name, x, y, width, height);
        this.lines = lines;
        this.reloadControls();
    }

    public String getSelected() {
        if (this.selected != -1) {
            return this.get(this.selected);
        }
        return "";
    }

    public void clear() {
        this.lines.clear();
        this.selected = -1;
        this.maxScroll = 0;
        this.scrolled.setStart(0.0);
        this.reloadControls();
    }

    public int size() {
        return this.lines.size();
    }

    public String get(int id) {
        return this.lines.get(id);
    }

    public void add(String input) {
        this.lines.add(input);
        this.reloadControls();
    }

    public void remove(int id) {
        this.lines.remove(id);
        this.reloadControls();
    }

    public void onLineClicked(GuiControl control) {
        int index = this.controls.indexOf(control);
        if (index != -1) {
            if (this.selected != -1 && this.selected < this.controls.size()) {
                ((GuiLabel)this.controls.get((int)this.selected)).color = 0xE0E0E0;
            }
            this.selected = index;
            ((GuiLabel)this.controls.get((int)this.selected)).color = 0xFFFF28;
            this.onSelectionChange();
        }
    }

    public void reloadControls() {
        this.controls.clear();
        for (int i = 0; i < this.lines.size(); ++i) {
            int color = 0xE0E0E0;
            if (i == this.selected) {
                color = 0xFFFF28;
            }
            GuiClickableLabel label = new GuiClickableLabel(this.lines.get(i), 0, i * 15, this.width - this.scrollbarWidth - 2 - this.getContentOffset() * 2, 8, color){

                @Override
                public int getColor() {
                    if (this.isMouseOver() && this.color != 0xFFFF28) {
                        return ColorUtils.RGBAToInt(new Color(255, 255, 100));
                    }
                    return this.color;
                }

                @Override
                public void onClicked(int x, int y, int button) {
                    GuiListBox.this.onLineClicked(this);
                }
            };
            this.controls.add(label);
        }
        this.refreshControls();
    }

    public void onSelectionChange() {
        this.raiseEvent(new GuiControlChangedEvent(this));
    }
}

